﻿using PpmsDataWebService.Models;
using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using System.Web.Http.Description;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class InstitutionsController : ODataController
    {
        [ODataRoute("Institutions({StationNumber})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string StationNumber)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Institution 
                var ppmsInstitution = context.ppms_institutionSet.FirstOrDefault(i => i.ppms_name.Contains(StationNumber));
                if (ppmsInstitution != null)
                {
                    var ppmsInstitutionsList = new List<ppms_institution> { ppmsInstitution };
                    var institutions = await InstitutionMap.MapInstitutions(ppmsInstitutionsList, queryType, context);
                    return Request.CreateResponse(institutions);
                }
            }
            var message = string.Format("Institution with Name: {0} not found", StationNumber);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Institutions({StationNumber})/Visn")]
        public async Task<HttpResponseMessage> GetVisn([FromODataUri] string StationNumber)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Institution 
                var ppmsInstitution = context.ppms_institutionSet.FirstOrDefault(i => i.ppms_name.Contains(StationNumber));
                if (ppmsInstitution != null)
                {
                    //Get the related Visn
                    var ppmsVisn =
                        context.va_visnSet.FirstOrDefault(i => i.Id == ppmsInstitution.ppms_visn.Id);
                    var ppmsVisnList = new List<va_visn> { ppmsVisn };
                    var visn =
                        await VisnMap.MapVisns(ppmsVisnList, "None", context);
                    return Request.CreateResponse(visn);
                }
            }
            var message = string.Format("Visns with Institution Name: {0} not found", StationNumber);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("Institutions")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Institutions in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsInstitutions = context.ppms_institutionSet.Where(i => i.ppms_name != null).Take(50);
                var ppmsInstitutionsList = ppmsInstitutions.ToList();
                if (ppmsInstitutionsList.Any())
                {
                    //Map Institution
                    var institutions = await InstitutionMap.MapInstitutions(ppmsInstitutionsList, "None", context);
                    return Request.CreateResponse(institutions);
                }
                var message = "No Institutions found"; 
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }       
    }
}